/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.storage.cells.CellState;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.core.localization.PlayerMessages;
import appeng.util.InteractionUtil;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public class ChestBlock
extends AEBaseEntityBlock<ChestBlockEntity> {
    private static final BooleanProperty LIGHTS_ON = BooleanProperty.m_61465_((String)"lights_on");

    public ChestBlock() {
        super(ChestBlock.defaultProps(Material.f_76279_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHTS_ON});
    }

    @Override
    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, ChestBlockEntity be) {
        CellState cellState = CellState.ABSENT;
        if (be.getCellCount() >= 1) {
            cellState = be.getCellStatus(0);
        }
        return (BlockState)currentState.m_61124_((Property)LIGHTS_ON, (Comparable)Boolean.valueOf(be.isPowered() && cellState != CellState.ABSENT));
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player p, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        ChestBlockEntity be = (ChestBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null && !InteractionUtil.isInAlternateUseMode(p)) {
            if (!level.m_5776_()) {
                if (hit.m_82434_() == be.getUp()) {
                    if (!be.openGui(p)) {
                        p.m_6352_((Component)PlayerMessages.ChestCannotReadStorageCell.text(), Util.f_137441_);
                    }
                } else {
                    be.openCellInventoryMenu(p);
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }
}

